#version 120

precision highp float;
vec3 light1 = vec3(0.5,0.5,0.9);
vec3 objdim = vec3(1.66, 0.14, 1.11)*20.0;
vec2 texCoordc;
vec2 uv;

#define MAX_LIGHTS 14
in vec3 alightVec[MAX_LIGHTS];

in vec2 texCoord;

uniform float testvalue;

in vec3 v;
in vec3 N;
in vec3 T;
in vec3 B;
in vec3 originalV;
in vec3 originalN;

uniform vec4 flash;
uniform vec4 glColor;
uniform vec3 camPos;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];



uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;


vec3 CalcBumpedNormal()
{
    vec3 Normal = N;
    vec3 Tangent = T;
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    
    vec3 Bitangent = B;
    vec3 BumpMapNormal;
    
    if (true)
        
        BumpMapNormal = texture2D(normalMap, uv).xyz;
    else
        BumpMapNormal = texture2D(normalMap, texCoordc).xyz;
    BumpMapNormal = normalize(2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0));
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}


float hash2(vec3 p)  
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noisefast2( in vec3 x )
{
    vec3 i = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash2(i+vec3(0,0,0)), 
                        hash2(i+vec3(1,0,0)),f.x),
                   mix( hash2(i+vec3(0,1,0)), 
                        hash2(i+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash2(i+vec3(0,0,1)), 
                        hash2(i+vec3(1,0,1)),f.x),
                   mix( hash2(i+vec3(0,1,1)), 
                        hash2(i+vec3(1,1,1)),f.x),f.y),f.z);
}

float noise (vec3 texpos){
    texpos/=75.0/0.3/testvalue;
    float c;
    c=noisefast2(texpos*10.0);
    c+=noisefast2(texpos*20.0);
    c+=noisefast2(texpos*30.0);
    c+=noisefast2(texpos*40.0);
    c+=noisefast2(texpos*60.0);
    c+=noisefast2(texpos*80.0);
    c/=6.0;
    return c;
}

void main (void)
{

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    texCoordc.x=(originalV.x/objdim.x+1.0)/2.0;
    texCoordc.y=(originalV.z/objdim.z+1.0)/2.0;

    
    if (true){
            
        vec3 uv2;
        uv2.x=(originalV.x/objdim.z+1.0)/2.0;
        uv2.y=(originalV.y/objdim.z+1.0)/2.0;
        uv2.z=(originalV.z/objdim.z+1.0)/2.0;
        float dx=abs(originalN.x);
        float dy=abs(originalN.y);
        float dz=abs(originalN.z);
        if (dx>=dy&&dx>=dz) {uv=uv2.zy; if (originalN.x<0) uv+=vec2(0.5,0);}
        else if (dy>=dx&&dy>=dz) {uv=uv2.xz;if (originalN.y<0) uv+=vec2(0.5,0);}
        else 
        {uv=uv2.xy; if (originalN.z<0) uv+=vec2(0.5,0);}
        base = texture2D(colorMap, uv);
    }
    else
        base = texture2D(colorMap, texCoordc);
    
    vAmbient = vec4(1.0f,1.0f,1.0f,1.0f)
               * vec4(lightsAmbientr[0],lightsAmbientg[0],lightsAmbientb[0],1.0f);
    

    vec3 viewDir = normalize(camPos-v);
    
    for (int i=0; i<1; i++)
    {
        if (true)
        {
            
            vec3 L = normalize(light1 - v);
            vec3 E = normalize(-v); 
            vec3 R = normalize(-reflect(L,N));
            vec3 lightDir = L;

                vec3 tmpVec = vec3(light1) - v;
	            vec3 alightVec; 
                alightVec.x = dot(tmpVec, T);            
            	alightVec.y = dot(tmpVec, B);
	            alightVec.z = dot(tmpVec, N);
                lightVec=alightVec;
            

            distSqr = dot(lightVec, lightVec);
            
            att = clamp(1.0 - 0.5 * sqrt(distSqr), 0.0, 1.0);
            
            lVec = lightVec * inversesqrt(distSqr);
            

            
            
            bump=CalcBumpedNormal();

            
            diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
            
            vDiffuse = vec4(lightsDiffuser[i],lightsDiffuseg[i],lightsDiffuseb[i],1.0f) * diffuse *
                       texture2D(lightMap, vec2(diffuse/1.02f,lightMapSelect[i]));

            
            
            diffuse = max(dot(bump,L), 0.0);
            vec4 Idiff = vec4 (lightsDiffuser[i],lightsDiffuseg[i],lightsDiffuseb[i],1.0f)* diffuse*
                        texture2D(lightMap, vec2(diffuse/1.02f,lightMapSelect[i]));
            Idiff = clamp(Idiff, 0.0, 1.0);

            accvDiffuse = accvDiffuse + Idiff *att;
            

            
            
            

            
            


            vec3 reflectDir=reflect(-lightDir,bump);
            const float shininess=1.5f;
            
            specular = pow(clamp(dot(viewDir,reflectDir)*shininess,0.0f,1.0f),1.2f); 
            
            
            

            

            vSpecular = vec4(lightsSpecularr[i],lightsSpecularg[i],lightsSpecularb[i],1.0f)* specular *
                        texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));


            
            
            
            
            
            
            
            
            
            
            vec4 Ispec=vec4(vec3(specular),1.0);
            Ispec = clamp(Ispec, 0.0, 1.0);

            
            accvSpecular = accvSpecular + Ispec * att;

            
            
        }
    }
    
    
    
    
    accvDiffuse=vec4(vec3(max(dot(bump,light1),-1.0)),1.0);
    
    
    gl_FragColor = ((vAmbient + accvDiffuse*base + accvSpecular)+vec4(0.1,0.2,0.3,1.0))*vec4(0.7,0.7,0.7,1.0);
    
    
    

    

    
    
    
}











